<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Zona;
use BackendBundle\Entity\Usuario;
 
 header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of ZonaController
 *
 * @author brianaboytesmorales
 */
class ZonaController extends Controller {

    public function newAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $json = $request->get("json", null);

        if ($json != null && $hash != null) {

            $params = json_decode($json);
            $authCheck = $helpers->authCheck($hash);

            if ($authCheck == true) { // si es un usuario valido entra
                $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                if ($idusuario != null) {
                    $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                    $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                            array(
                                "idusuario" => $idusuario,
                            )
                    );

                    $permisos = $user->getIdrol()->getPermisos();

                    if ($permisos == 1 || $permisos == 2) {
                        $nomzona = ( $params->nombrezona != null ) ? $params->nombrezona : null;

                        if ($nomzona != null) {

                            $isset_zona = $em->getRepository("BackendBundle:Zona")->findBy(
                                    array(
                                        "nombrezona" => $nomzona
                                    )
                            );

                            if (count($isset_zona) == 0) {

                                try {
                                    $db = $em->getConnection();
                                    $query = "INSERT INTO "
                                            . "zona"
                                            . "(nombrezona)"
                                            . "VALUES"
                                            . "('{$nomzona}')";


                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "zona creada!!"
                                    );
                                } catch (Exception $ex) {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Error en la coneccion con la BD"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 402,
                                    "msg" => "La zona ya existe en la BD!!"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "Ingrese un dato!!"
                            );
                        }
                    }
                }
            }
        }
        return $helpers->json($data);
    }

    public function deleteAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);


        $json = $request->get("json", null);
        if ($json != null && $hash != null) {
            $authCheck = $helpers->authCheck($hash);
            $params = json_decode($json);

            if ($authCheck == true) { // si es un usuario valido entra
                $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                if ($idusuario != null) {
                    $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                    $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                            array(
                                "idusuario" => $idusuario,
                            )
                    );

                    $permisos = $user->getIdrol()->getPermisos();

                    if ($permisos == 1 || $permisos == 2) {

                        $idzona = ( $params->idzona != null ) ? $params->idzona : null;

                        if ($idzona != null) {

                            $isset_zona = $em->getRepository("BackendBundle:Zona")->findBy(
                                    array(
                                        "idzona" => $idzona
                                    )
                            );

                            if (count($isset_zona) != 0) {

                                try {
                                    $db = $em->getConnection();
                                    $query = "DELETE FROM "
                                            . "zona"
                                            . " WHERE"
                                            . " idzona ="
                                            . " {$idzona}";


                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "zona eliminada!!"
                                    );
                                } catch (Exception $ex) {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Error en la coneccion con la BD"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "La zona no existe en la BD!!"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "Ingrese un dato!!"
                            );
                        }
                    }
                }
            }
        }
        return $helpers->json($data);
    }

    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);


        if ($hash != null) {

            $authCheck = $helpers->authCheck($hash);

            if ($authCheck == true) { // si es un usuario valido entra
                $json = $request->get("json", null);
                $params = json_decode($json);
                $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                if ($idusuario != null) {
                    $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                    $db = $em->getConnection();
                    $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                            array(
                                "idusuario" => $idusuario,
                            )
                    );

                    if (count($isset_user) != 0) {
                        if ($json != null) {

                            $idzona = ( $params->idzona != null ) ? $params->idzona : null;

                            if ($idzona != null) {
$query = "SELECT * FROM zona where zonaactiva = 1 AND idzona = {$idzona}";

                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_zona = $stmt->fetchAll();

                                if (count($isset_zona) != 0) {

                                    try {
                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "zona encontrada!!",
                                            "zona" => $isset_zona
                                        );
                                    } catch (Exception $ex) {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "Error en la coneccion con la BD"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "La zona no existe en la BD!!"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Ingrese un dato!!"
                                );
                            }
                        } else {

                            $query = "SELECT * FROM zona where zonaactiva = 1";

                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $isset_zona = $stmt->fetchAll();

                            if (count($isset_zona) != 0) {

                                try {
                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "zonas encontradas!!",
                                        "zona" => $isset_zona
                                    );
                                } catch (Exception $ex) {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Error en la coneccion con la BD"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "no hay zonas en la BD!!"
                                );
                            }
                        }
                    }
                }
            }
        }

        return $helpers->json($data);
    }
    
    public function updateAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $json = $request->get("json", null);

        if ($json != null && $hash != null) {

            $params = json_decode($json);
            $authCheck = $helpers->authCheck($hash);

            if ($authCheck == true) { // si es un usuario valido entra
                $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 
                $rol = ( $identity->idrol != null ) ? $identity->idrol : null;
                if ($idusuario != null) {
                    $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                    $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                            array(
                                "idusuario" => $idusuario,
                            )
                    );
                    
                    $permisos = $user->getIdrol()->getPermisos();

                    if ($rol == 1 || $rol == 2) { 
                        
                        $nomzona = ( $params->nombrezona != null ) ? $params->nombrezona : null;
                        $idzona = ( $params->idzona != null ) ? $params->idzona : null;
                        $zonaactiva = ( $params->zonaactiva != null ) ? $params->zonaactiva : null;

                        if ($idzona != null && $nomzona != null) {

                            $isset_zona = $em->getRepository("BackendBundle:Zona")->findBy(
                                    array(
                                        "idzona" => $idzona
                                    )
                            );

                            if (count($isset_zona) != 0) {

                                try {
                                    $db = $em->getConnection();
                                    $query = "UPDATE "
                                            . "zona"
                                            . " SET "
                                            . "nombrezona = '{$nomzona}', zonaactiva = {$zonaactiva} "
                                            . " WHERE "
                                            . "idzona = {$idzona}";


                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "zona actualizada!!"
                                    );
                                } catch (Exception $ex) {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Error en la coneccion con la BD"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "La zona ya existe en la BD!!"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "Ingrese un dato!!"
                            );
                        }
                    }
                }
            }
        }
        return $helpers->json($data);
    }
    

}
