<?php
namespace AppBundle\Controller;

use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Usuario;
use Symfony\Bundle\FrameworkBundle\Controller\Controller;

header('Access-Control-Allow-Origin: *');
header('Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method');
header('Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE');
header('Allow: GET, POST, OPTIONS, PUT, DELETE');
//header('Content-Type: application/json');
//header('Content-Type: application/form-data');
//header('"Access-Control-Allow-Headers" : "Content-Type"');
//header('Access-Control-Allow-Headers: Authorization');

//eyJ0eXAiOiJKV1QiLCJhbGciOiJIUzI1NiJ9.eyJzdWIiOjEsIm5vbWJyZXMiOiJCcmlhbiAiLCJhcGVsbGlkb3MiOiJBYm95dGVzIE1vcmFsZXMgIiwiY29udHJhc2VuYSI6IjkzZmEzZTQ2MjQ2NzZmMmU5YWExNDM5MTExMThiNDU0NzA4N2U5YjZlMGI2MDc2ZjJlMTAyN2Q3YTJkYTJiMGEiLCJjb3JyZW8iOiJicmF5YW45MzJAZ21haWwuY29tIiwicmZjIjoieHh4eHh4eHh4eHgiLCJpZGNpdWRhZCI6MTQsImlkcm9sIjoxfQ.hiLgVrqQIj2cFEbXYMNBxFhM6peCeaVa-XNpej3HZ_Y
class UsuarioController extends Controller {

    public function newAction(Request $request) {

        //instacia con los servicios
        $helpers = $this->get("app.helpers");

        //Obtencion del json 
        $json = $request->get("json", null);
        $params = json_decode($json);

        //Variable de informacion 
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "user not created"
        );

        //validacion del JSON
        if ($json != null) {
            //validacion de informacion del contenido del json
            $nombres = (isset($params->nombres) ) ? $params->nombres : null;
            $apellidos = (isset($params->apellidos)) ? $params->apellidos : null;
            //$fechaCreacion = (isset($params->fecha_creacion)) ? $params->fecha_creacion : null;
            $contrasena = (isset($params->contrasena)) ? $params->contrasena : null;
            $correo = (isset($params->correo)) ? $params->correo : null;
            $idrol = (isset($params->idrol)) ? $params->idrol : null;
            $idciudad = (isset($params->idciudad)) ? $params->idciudad : null;
            $rfc = (isset($params->rfc)) ? $params->rfc : null;
            $foto = (isset($params->foto)) ? $params->foto : null;
            $telefono = (isset($params->telefono)) ? $params->telefono : null;
            $celular = (isset($params->celular)) ? $params->celular : null;
            $activo = (isset($params->activo)) ? $params->activo : 1;
            $emailContrint = new Assert\Email();
            $emailContrint->message = "this email is not valid";

            $validate_email = $this->get("validator")->validate($correo, $emailContrint);

            //Validacion de informacion 
            if ($correo != null && count($validate_email) == 0 &&
                    $contrasena != null && $nombres != null && $apellidos != null &&
                    $idrol != null && $idciudad != null && $rfc != null && $celular != null) {
                //cifrado de password
                $pwd = hash('sha256', $contrasena);
                
                //Instancia con el ORM
                $em = $this->getDoctrine()->getManager();

                $isset_user = $em->getRepository("BackendBundle:Usuario")->findBy(
                        array(
                            "correo" => $correo
                        )
                );
                

                //Validacion de existencia de usuario en la BD
                //insercion de datos en la BD
                if (count($isset_user) == 0) {
          
                    $db = $em->getConnection();
                    $query = "INSERT INTO "
                            . "usuario"
                            . "(idrol,idciudad,nombres,apellidos,correo,contrasena,rfc,foto,telefono,celular,usractivo)"
                            . "VALUES"
                            . "({$idrol},{$idciudad},'{$nombres}','{$apellidos}','{$correo}','{$pwd}','{$rfc}','{$foto}','{$telefono}','{$celular}',{$activo})";


                    $stmt = $db->prepare($query);
                    $params = array();
                    $stmt->execute($params);
                    
                    

                    $data["status"] = 'success';
                    $data["code"] = 200;
                    $data["msg"] = 'New user created !!';
                } else {
                    $data = array(
                        "status" => "error",
                        "code" => 401,
                        "msg" => "user not created, DUPLICATED!!"
                    );
                }
            }
        }else{
            $data = array(
                        "status" => "error",
                        "code" => 400,
                        "msg" => "user not created"
                    );
        }

        return $helpers->json($data);
    }
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        
                        if (count($isset_user) != 0) {
                            
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                            
                            $json = $request->get("json", null);
                            
                            $jsondecode = json_decode($json);
                            $pagina = ( $jsondecode->pagina != null ) ? $jsondecode->pagina : null;
                            $estatus = ( $jsondecode->status != null ) ? $jsondecode->status : null;
                            
                            $where = ""; //variable del where para la busqueda de reportes por estatus
                            //$inicio = 0; //princiopio de busqueda en la bd por reporte
                            //
                            //DESIGNAR BUSQUEDA POR ESTATUS
                            if($estatus == 0){
                                $where = "AND idrol = 1 OR idusuario = 2 OR idusuario = 3";
                            } else {
                                $where = "AND idrol = {$estatus}";
                            }
                            //PAGINACION: OBTENCION DE DATOS POR PARTES
                            /*if( $pagina > 15) {
                                $inicio = $pagina - 15;
                            }*/
                            
                            if ($pagina === null || $pagina === "") {
                                $pagina = 0;
                            }
                            
                            //var_dump($pagina);
                            if ($idrol == 1 || $idrol == 2) {

                                $query = "SELECT * FROM "
                                        . "usuario "
                                        . "LEFT JOIN "
                                        . "ciudad ON usuario.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN estado ON ciudad.idestado = estado.idestado "
                                        . "LEFT JOIN zona ON estado.idzona = zona.idzona "
                                        . "WHERE usuario.usractivo = 1 {$where} "
                                        . "ORDER BY usuario.idusuario DESC LIMIT {$pagina}, 15 ";
                            } 

                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "usuarios encontrados!!",
                                    "usuarios" => $reportes
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "no hay usuarios!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    public function busquedaidAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        
                        if (count($isset_user) != 0) {
                            
                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                            
                            $json = $request->get("json", null);
                            
                            $jsondecode = json_decode($json);
                            $id = ( $jsondecode->id != null ) ? $jsondecode->id : null;
                         
                            //var_dump($pagina);
                            if ($idrol == 1 || $idrol == 2) {

                                $query = "SELECT * FROM "
                                        . "usuario "
                                        . "LEFT JOIN "
                                        . "ciudad ON usuario.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN estado ON ciudad.idestado = estado.idestado "
                                        . "LEFT JOIN zona ON estado.idzona = zona.idzona "
                                        . "WHERE usuario.idusuario = {$id} AND usuario.usractivo = 1 "
                                        . "ORDER BY usuario.idusuario";
                            } 

                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "usuarios encontrados!!",
                                    "usuarios" => $reportes
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "no hay usuarios!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    public function busquedainteligenteAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $idusuario = ( $jsondecode->idusuario != null ) ? $jsondecode->idusuario : null;
                            $idrol = ( $jsondecode->idrol != null ) ? $jsondecode->idrol : null;
                            $idciudad = ( $jsondecode->idciudad != null ) ? $jsondecode->idciudad : null;

                            $nombre = ( $jsondecode->nombre != null ) ? $jsondecode->nombre : null;
                            $apellido = ( $jsondecode->apellido != null ) ? $jsondecode->apellido : null;
                            $rfc = ( $jsondecode->rfc != null ) ? $jsondecode->rfc : null;
                            $telefono = ( $jsondecode->telefono != null ) ? $jsondecode->telefono : null;
                            $celular = ( $jsondecode->celular != null ) ? $jsondecode->celular : null;
                            $pagina = ( $jsondecode->pagina != null ) ? $jsondecode->pagina : null;
                            $correo = ( $jsondecode->correo != null ) ? $jsondecode->correo : null;
                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */

                            $wheresql = "";
                            $inicio = 0; //princiopio de busqueda en la bd por reporte
                            if ($pagina > 15) {
                                $inicio = $pagina - 15;
                            }

                            if ($idusuario != NULL || $idrol != NULL || $idciudad != NULL || $nombre != NULL 
                                    || $apellido != NULL || $rfc != NULL || $telefono != NULL || $celular != NULL || $correo != NULL) {
                                
                                $wheresql = "{$wheresql} WHERE ";
                                
                                if ($idusuario != NULL) {
                                     $wheresql = " {$wheresql} usuario.idusuario = {$idusuario} ";
                                    
                                    if($idrol != NULL || $idciudad != NULL || $nombre != NULL || $apellido != NULL 
                                            || $rfc != NULL || $telefono != NULL || $celular != NULL || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($idrol != NULL) {
                                    $wheresql = " {$wheresql} usuario.idrol = {$idrol} ";
                                    if($idciudad || $nombre || $apellido || $rfc || $telefono || $celular || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($idciudad != NULL) {
                                    $wheresql = " {$wheresql} usuario.idciudad = {$idciudad} ";
                                    if($nombre || $apellido || $rfc || $telefono || $celular || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($nombre != NULL) {
                                    $wheresql = " {$wheresql} usuario.nombres = '{$nombre}' ";
                                    if($apellido || $rfc || $telefono || $celular || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($apellido != NULL) {
                                    $wheresql = " {$wheresql} usuario.apellidos = '{$apellido}' ";
                                    if($rfc != NULL || $telefono != NULL || $celular != NULL || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($rfc != NULL) {
                                    $wheresql = " {$wheresql} usuario.rfc = '{$rfc}' ";
                                    if($telefono != NULL || $celular != NULL || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($telefono != NULL) {
                                    $wheresql = " {$wheresql} usuario.telefono = '{$telefono}' ";
                                    if( $celular != NULL || $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                }

                                if ($celular != NULL) {
                                    
                                    if( $correo != NULL) {
                                        $wheresql = " {$wheresql} AND ";
                                    }
                                    $wheresql = " {$wheresql} usuario.celular = '{$celular}' ";
                                }
                                
                                if ($correo != NULL) {
           
                                    $wheresql = " {$wheresql} usuario.correo = '{$correo}' ";
                                }
                            }
                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */

                            //var_dump($pagina);
                            //if ($idrol == 1 || $idrol == 2) {

                                $query = "SELECT * FROM "
                                        . "usuario "
                                        . "LEFT JOIN "
                                        . "ciudad ON usuario.idciudad = ciudad.idciudad "
                                        . "LEFT JOIN estado ON ciudad.idestado = estado.idestado "
                                        . "LEFT JOIN zona ON estado.idzona = zona.idzona "
                                        . "{$wheresql} AND usuario.usractivo = 1 "
                                        . "ORDER BY usuario.idusuario DESC LIMIT $inicio,{$pagina} ";
                            //}

                            //var_dump($query);
                            //die();
                            
                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $reportes = $stmt->fetchAll();

                            if (count($reportes) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "usuarios encontrados!!",
                                    "usuarios" => $reportes
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "no hay usuarios!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    /* SUBIR IMAGEN DE USUARIO */
    public function uploadImageAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $file = $request->files->get("image");
                            //var_dump($file);
                            //die();
                            $ext = $file->guessExtension(); //obtenemos la extencion
                            if (!empty($file) && $file != null) {
                                if ( $ext == "jpeg" || $ext == "jpg" || $ext == "png" || $ext == "gif") {
                                    
                                    $file_name = time() . "." . $ext; //le asignamos un nombre diferente
                                    $file->move("uploads/users", $file_name); //subir al fichero
                                    ///aqui va el insert sql
                                    
                                    $json = $request->get("json", null);

                                    $jsondecode = json_decode($json);

                                    $idusuario = ( $jsondecode->idusuario != null ) ? $jsondecode->idusuario : null;


                                    $query = "UPDATE usuario "
                                            . "SET foto = 'https://apiitc.itcdemexico.com/suportapi/web/uploads/users/{$file_name}' "
                                            . "WHERE idusuario = {$idusuario}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "Imagenes cargadas correctamente!!"
                                    );
                                } else {
                                    $data = array(
                                    "status" => "error",
                                    "code" => 402,
                                    "msg" => "Filet not valid!!"
                                );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 401,
                                    "msg" => "erro al cargar imagenes!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function updateAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {


                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1 || $idrol == 2) {

                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {


                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $params = json_decode($json);

                                    //validacion de informacion del contenido del json
                                    $idusuario = (isset($params->idusuario) ) ? $params->idusuario : null;
                                    $nombres = (isset($params->nombres) ) ? $params->nombres : null;
                                    $apellidos = (isset($params->apellidos)) ? $params->apellidos : null;
                                    //$fechaCreacion = (isset($params->fecha_creacion)) ? $params->fecha_creacion : null;
                                    $contrasena = (isset($params->contrasena)) ? $params->contrasena : null;
                                    $correo = (isset($params->correo)) ? $params->correo : null;
                                    $idrol = (isset($params->idrol)) ? $params->idrol : null;
                                    $idciudad = (isset($params->idciudad)) ? $params->idciudad : null;
                                    $rfc = (isset($params->rfc)) ? $params->rfc : null;
                                    $telefono = (isset($params->telefono)) ? $params->telefono : null;
                                    $celular = (isset($params->celular)) ? $params->celular : null;
                                    $usractivo = (isset($params->usractivo)) ? $params->usractivo : null;
                                    

                                    /* VALIDA QUE LOS PARAMETROS NECESARIOS NO SEAN NULOS */
                                    if ($idusuario != null && $nombres != null && $apellidos != null && $idrol != null && $idciudad != null && $rfc != null) {


                                        /* BUSCAR SI EL USUARIO YA EXISTE EN LA BASE D EDATOS */
                                        $em = $this->getDoctrine()->getManager(); // instancia con doctrine
                                        $pwd = $contrasena;
                                        
                                        
                                        $setpw = "";
                                        
                                        if ($contrasena != null) {
                                            $pwd = hash('sha256', $contrasena);
                                            $setpw = ",contrasena='{$pwd}'";
                                        }
                                        
                                        if ($correo != null) {
                                            $isset_user = $em->getRepository("BackendBundle:Usuario")->findBy(
                                                    array(
                                                        "correo" => $correo
                                                    )
                                            );

                                            /* SI NO REGRESA TUPLAS ES POR QUE NO EXISTE Y SE PUEDE CREAR */
                                            if (count($isset_user) == 0) {
                                                $db = $em->getConnection(); // se hace la conexion
                                                //encripta la contraseña
                                                /* CONSULTA SQL (recordar siempre dejar un espacio al final de cada string) */

                                                $query = "UPDATE usuario "
                                                        . "SET idrol={$idrol}, idciudad={$idciudad}, nombres='{$nombres}',apellidos='{$apellidos}',correo='{$correo}'$setpw,telefono='{$telefono}',celular='{$celular}', rfc ='{$rfc}', usractivo={$usractivo} "
                                                        . "WHERE idusuario={$idusuario}";

                                                $stmt = $db->prepare($query);
                                                $params = array();
                                                $stmt->execute($params);

                                                $data = array(
                                                    "status" => "Sucess!",
                                                    "code" => 200,
                                                    "msg" => "user created"
                                                );
                                            } else {
                                                $data = array(
                                                    "status" => "error",
                                                    "code" => 402,
                                                    "msg" => "Correo ya registrado"
                                                );
                                            }
                                        } else {

                                            $db = $em->getConnection(); // se hace la conexion
                                            $pwd = hash('sha256', $contrasena); //encripta la contraseña
                                            /* CONSULTA SQL (recordar siempre dejar un espacio al final de cada string) */
                                            $query = "UPDATE usuario "
                                                    . "SET idrol={$idrol}, idciudad={$idciudad}, nombres='{$nombres}',apellidos='{$apellidos}' $setpw,telefono='{$telefono}',celular='{$celular}', rfc ='{$rfc}', usractivo={$usractivo} "
                                                    . "WHERE idusuario={$idusuario}";

                                            $stmt = $db->prepare($query);
                                            $params = array();
                                            $stmt->execute($params);

                                            $data = array(
                                                "status" => "Sucess!",
                                                "code" => 200,
                                                "msg" => "usuario actualizado"
                                            );
                                        }
                                    } else {

                                        /* SI FALTA ALGUN DATO PRIMORDIAL MANDA ESTOS DATOS */
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Faltan datos"
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
}
