<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Zona;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of SubcorporativoController
 *
 * @author brianaboytesmorales
 */
class SubcorporativoController extends Controller {

    public function insertAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json, true);

                                    /* DATOS DE LA SOLICITUD */
                                    //$encuesta = ( (array)$jsondecode->encuesta != null ) ? (array)$jsondecode->encuesta : null;
                                    $db = $em->getConnection();
                                    foreach ($jsondecode as $row) 
                                    {
                                        $idusuariosubcorp = $row['idusuariosubcorp'];
                                        $idsubcorporativo = $row['idcorporativo'];
                                       

                                        $queryVerifica = "select * from coberturascor "
                                                . "WHERE idusuariosubcorp = {$idusuariosubcorp} AND idsubcorporativo = {$idsubcorporativo}";

                                        $stmtver = $db->prepare($queryVerifica);
                                        $paramsver = array();
                                        $stmtver->execute($paramsver);
                                        $encuestas = $stmtver->fetchAll();
                                        
                                        if (count($encuestas) == 0) {
                                            $query = "INSERT INTO coberturascor(idusuariosubcorp, idsubcorporativo)"
                                                    . "VALUES ($idusuariosubcorp, $idsubcorporativo)";


                                            $stmt = $db->prepare($query);
                                            $params = array();
                                            $stmt->execute($params);
                                        }
                                    }

                                    $data = array(
                                        "status" => "Sucess!",
                                        "code" => 200,
                                        "msg" => "encuesta insertada"
                                    );

                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
     public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $jsondecode = json_decode($json);

                                $idusuariosubcorp = ($jsondecode->idusuariosubcorp != null ) ? $jsondecode->idusuariosubcorp : null;
                                
                                    $query = "SELECT * FROM "
                                    . "coberturascor "
                                    . "LEFT JOIN "
                                            . "corporativo on corporativo.idcorporativo = coberturascor.idsubcorporativo "
                                    . "LEFT JOIN "
                                            . "ciudad on corporativo.idciudad = ciudad.idciudad "
                                    . "LEFT JOIN "
                                            . "estado on estado.idestado = ciudad.idestado  LEFT JOIN zona on zona.idzona = estado.idzona LEFT JOIN usuario on usuario.idusuario = corporativo.idusuario "
                                    . "WHERE  idusuariosubcorp = {$idusuariosubcorp} AND corporativo.activo = 1 ";

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_corp = $stmt->fetchAll();

                                if (count($isset_corp) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "subcorporativos encontradas!!",
                                        "subcorporativos" => $isset_corp
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 402,
                                        "msg" => "los subcorporativos no existe en la BD!!"
                                    );
                                }
                            } else {
                                    $query = "SELECT * FROM "
                                    . "coberturascor "
                                    . "LEFT JOIN usuario on usuario.idusuario = coberturascor.idusuariosubcorp "
                                    . "LEFT JOIN corporativo on corporativo.idcorporativo = coberturascor.idsubcorporativo ";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_ciudad = $stmt->fetchAll();

                                if (count($isset_ciudad) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "encuestas encontradas!!",
                                        "encuesta" => $isset_ciudad
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 402,
                                        "msg" => "no hay encuestas!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function deleteAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json);

                                    $idcorporativo = ($jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                    $idusuariosubcorp = ($jsondecode->idusuariosubcorp != null ) ? $jsondecode->idusuariosubcorp : null;

                                    $query = "DELETE FROM coberturascor where idsubcorporativo = {$idcorporativo} AND idusuariosubcorp = {$idusuariosubcorp}";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);
                                    
                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "cobertura eliminada!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

}
