<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Modelo;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of ModeloController
 *
 * @author brianaboytesmorales
 */
class ModeloController extends Controller {

    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $query = "SELECT * "
                                    . "FROM "
                                    . "modelo "
                                    . "WHERE modeloactivo = 1";


                            $db = $em->getConnection();
                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $isset_ciudad = $stmt->fetchAll();

                            if (count($isset_ciudad) != 0) {

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "Modelos encontradas!!",
                                    "modelo" => $isset_ciudad
                                );
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "El modelo no existe en la BD!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function insertAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json);

                                    /* DATOS DE LA SOLICITUD */
                                    $nombremodelo = ( $jsondecode->nombremodelo != null ) ? $jsondecode->nombremodelo : null;

                                    /* SI DATA EXISTE ENTRA A EJECUTAR LA CONSULTA */
                                    if ($nombremodelo != null ) {

                                        $query = "INSERT INTO "
                                                . "modelo (nombremodelo) "
                                                . "VALUES ('$nombremodelo');";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);

                                        $data = array(
                                            "status" => "Sucess!",
                                            "code" => 200,
                                            "msg" => "modelo creado"
                                        );
                                    } else {

                                        /* SI FALTA ALGUN DATO PRIMORDIAL MANDA ESTOS DATOS */
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Faltan datos"
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function updateAction(Request $request) {

        /* MENSAJE POR DEFECTO SI NO SE CUMPLE NINGUNA DE LAS VALIDACIONES */
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        /* TRY-CATCH POR SI HAY UN ERROR EN LA EJECUCION */
        try {

            /* OBTENERMOS EL API KEY DEL REQUEST */
            $hash = $request->get("authorization", null);

            /* SI EXISTE EL API KEY ENTRA */
            if ($hash != null) {

                /* HACEMOS LA INSTANCIA CON LOS SERVICIOS HELPERS */
                $helpers = $this->get("app.helpers");

                /* LIBRERIAS DE LOS SERVICIOS DE AUTENTIFICACION DE LA APY KEY */
                $authCheck = $helpers->authCheck($hash);

                /* COMPRUEBA SI ES UNA APY KEY VALIDA */
                if ($authCheck == true) {

                    /* OBTIENE LOS DATOS DEL USUARIO DE LA APY KEY */
                    $identity = $helpers->authCheck($hash, true);

                    /* OBTIENE EL ID DEL USUARIO */
                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null;

                    /* SI EL ID DEL USUARIO ES DIFERENTE DE NULL ENTRA */
                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 

                        /* BUSCAMOS EL USUARIO EN LA BASE DE DATOS */
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                        /* SI EXISTE EL USUARIO ENTRA */
                        if (count($isset_user) != 0) {

                            /* VALIDA LOS ROLES DE USUARIO */
                            if ($idrol == 1 || $idrol == 2) {
                                /* OBTIENE EL JSON DEL REQUEST */
                                $json = $request->get("json", null);

                                /* VALIDA SI EXISTE EL JSON */
                                if ($json != null) {

                                    /* DECODIFICA EL JSON PARA USAR SUS DATOS */
                                    $jsondecode = json_decode($json);

                                    /* DATOS DE LA SOLICITUD */
                                    $idmodelo = ( $jsondecode->idmodelo != null ) ? $jsondecode->idmodelo : null;
                                    $nombremodelo = ( $jsondecode->nombremodelo != null ) ? $jsondecode->nombremodelo : null;
                                    $modeloactivo = ( $jsondecode->modeloactivo != null ) ? $jsondecode->modeloactivo : null;
                                    /* SI DATA EXISTE ENTRA A EJECUTAR LA CONSULTA */
                                    if ($idmodelo != null && $nombremodelo != null) {

                                        $query = "UPDATE modelo "
                                                . "SET "
                                                . "nombremodelo = '{$nombremodelo}', "
                                                . "modeloactivo= {$modeloactivo} "
                                                . " WHERE idmodelo = {$idmodelo};";

                                        $db = $em->getConnection();
                                        $stmt = $db->prepare($query);
                                        $params = array();
                                        $stmt->execute($params);

                                        $data = array(
                                            "status" => "Sucess!",
                                            "code" => 200,
                                            "msg" => "modelo actualizado"
                                        );
                                    } else {

                                        /* SI FALTA ALGUN DATO PRIMORDIAL MANDA ESTOS DATOS */
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "Faltan datos"
                                        );
                                    }
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            /* SI HAY ALGUN ERROR EN LA EJECUCION MANDA ESTOS DATOS */
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

}
