<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Estado;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of EstadoController
 *
 * @author brianaboytesmorales
 */
class EstadoController extends Controller {

    public function newAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        try {

            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);
            $json = $request->get("json", null);

            if ($json != null && $hash != null) {

                $params = json_decode($json);
                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $permisos = $user->getIdrol()->getPermisos();

                        if ($permisos == 1 || $permisos == 2) {
                            $nombreestado = ( $params->nombreestado != null ) ? $params->nombreestado : null;
                            $idzona = ( $params->idzona != null ) ? $params->idzona : null;

                            if ($nombreestado != null && $idzona != null) {

                                $isset_zona = $em->getRepository("BackendBundle:Estado")->findBy(
                                        array(
                                            "nombreestado" => $nombreestado
                                        )
                                );

                                if (count($isset_zona) == 0) {


                                    $db = $em->getConnection();
                                    $query = "INSERT INTO "
                                            . "estado "
                                            . "(idzona,nombreestado) "
                                            . "VALUES "
                                            . "({$idzona},'{$nombreestado}')";


                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "estado creado!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "El estado ya existe en la BD!!"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Ingrese un dato!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idestado = ( $params->idestado != null ) ? $params->idestado : null;

                                if ($idestado != null) {

                                    $query = "SELECT "
                                            . "* "
                                            . "FROM "
                                            . "estado "
                                            . "LEFT JOIN "
                                            . "zona on zona.idzona = estado.idzona "
                                            . "WHERE "
                                            . "idestado = {$idestado} AND estadoactivo = 1";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_estado = $stmt->fetchAll();

                                    if (count($isset_estado) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "estado encontrado!!",
                                            "estado" => $isset_estado
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "El estado no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } else {

                                $query = "SELECT "
                                            . "* "
                                            . "FROM "
                                            . "estado "
                                            . "LEFT JOIN "
                                            . "zona on zona.idzona = estado.idzona WHERE estadoactivo = 1 ORDER BY (nombreestado)";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_estado = $stmt->fetchAll();
                                if (count($isset_estado) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "estados encontradas!!",
                                        "estado" => $isset_estado
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay estados en la BD!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
     public function updateAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $json = $request->get("json", null);

        if ($json != null && $hash != null) {

            $params = json_decode($json);
            $authCheck = $helpers->authCheck($hash);

            if ($authCheck == true) { // si es un usuario valido entra
                $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 
                $rol = ( $identity->idrol != null ) ? $identity->idrol : null;
                if ($idusuario != null) {
                    $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                    $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                            array(
                                "idusuario" => $idusuario,
                            )
                    );

                    $permisos = $user->getIdrol()->getPermisos();

                    if ($rol == 1 || $rol == 2) {

                        $nombreestado = ( $params->nombreestado != null ) ? $params->nombreestado : null;
                        $idzona = ( $params->idzona != null ) ? $params->idzona : null;
                        $idestado = ( $params->idestado != null ) ? $params->idestado : null;
                        $estadoactivo = ( $params->estadoactivo != null ) ? $params->estadoactivo : null;

                        if ($idestado != null && $nombreestado != null) {

                            try {
                                $db = $em->getConnection();
                                $query = "UPDATE "
                                        . "estado "
                                        . " SET "
                                        . "nombreestado = '{$nombreestado}', idzona = {$idzona}, estadoactivo = {$estadoactivo} "
                                        . " WHERE "
                                        . "idestado = {$idestado}";


                                $stmt = $db->prepare($query);
                                $params = array();
                                $stmt->execute($params);

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "estado actualizada!!"
                                );
                            } catch (Exception $ex) {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Error en la coneccion con la BD"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "Ingrese un dato!!"
                            );
                        }
                    }
                }
            }
        }
        return $helpers->json($data);
    }
}
