<?php

namespace AppBundle\Controller;

/**
 * Description of EstadisticaController
 *
 * @author brianaboytesmorales
 */

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Usuario;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

class EstadisticaController extends Controller {
    
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;
                            

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);
                            
                            $mes = ( $jsondecode->mes != null ) ? $jsondecode->mes : null;
                            $ano = ( $jsondecode->ano != null ) ? $jsondecode->ano : null;

                            //var_dump($pagina);
                            // if ($idrol == 1 || $idrol == 5 || $idrol == 6) {

                            /* $query = "SELECT * FROM estadisticas";

                              $db = $em->getConnection();
                              $stmt = $db->prepare($query);

                              $params = array();

                              $stmt->execute($params);

                              $datasetfechas = $stmt->fetchAll(); */
                            $db = $em->getConnection();
                            $where = "";
                            if ($idrol == 6) {
                                
                                 $idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                 $wherecorpo = "";
                                if( $idcorporativo != -10 || $idcorporativo != "-10"){
                                    $wherecorpo = " AND coberturascor.idsubcorporativo = {$idcorporativo} ";
                                }
                                
                                $where = " LEFT JOIN 
                                                corporativo on corporativo.idcorporativo = reporte.idcorporativo 
                                            LEFT JOIN  
                                                coberturascor on corporativo.idcorporativo = coberturascor.idsubcorporativo 
                                                WHERE 
                                            (coberturascor.idusuariosubcorp = {$idusuario} {$wherecorpo}) AND ";
                            }
                            if ($idrol == 5) {
                                $where=" LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                        WHERE 
                                            corporativo.idusuario = {$idusuario} AND ";
                            }
                            if ($idrol == 1 || $idrol == 2) {
                                $where=" WHERE ";
                                
                                if ($jsondecode->idcorporativo) {
                                    $idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                    if ($idcorporativo != -10 || $idcorporativo != "-10") {
                                        $where = " LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                        WHERE 
                                            (corporativo.idcorporativo = {$idcorporativo}) AND ";
                                    } else {
                                        $where = " WHERE ";
                                    }
                                } else {
                                    $where = " WHERE ";
                                }
                                
                                /*$idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                 if( $idcorporativo != -10 || $idcorporativo != "-10" || $idcorporativo != null){
                                    $where=" LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                        WHERE 
                                            (corporativo.idcorporativo = {$idcorporativo}) AND ";
                                } else {
                                    $where=" WHERE ";
                                }*/
                                
                            }

                            $query = "SELECT COUNT(idreporte) as abierto FROM reporte $where MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} AND  idestatus = 1";

                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $estatus1 = $stmt->fetchAll();

                            $query = "SELECT COUNT(idreporte) as asignado FROM reporte $where MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} AND  idestatus = 2";

                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $estatus2 = $stmt->fetchAll();

                            $query = "SELECT COUNT(idreporte) as enruta FROM reporte $where MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} AND  idestatus = 3";

                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $estatus3 = $stmt->fetchAll();
                            
                            $query = "SELECT COUNT(idreporte) as concluido FROM reporte $where (MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano}) AND  (idestatus = 4  OR  idestatus = 5)";

                            $stmt = $db->prepare($query);

                            $params = array();

                            $stmt->execute($params);

                            $estatus4 = $stmt->fetchAll();

                            $data = array(
                                "status" => "succes!!",
                                "code" => 200,
                                "msg" => "estadisticas encontradas!!",
                                "Estados" => array(
                                    $estatus1[0],
                                    $estatus2[0],
                                    $estatus3[0],
                                    $estatus4[0]
                                )
                            );
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function grapAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            if ($json != null) {
                                $jsondecode = json_decode($json);

                                $mes = ( $jsondecode->mes != null ) ? $jsondecode->mes : null;
                                $ano = ( $jsondecode->ano != null ) ? $jsondecode->ano : null;
                                $tiporeporte = ( $jsondecode->tiporeporte != null ) ? $jsondecode->tiporeporte : null;

                                if ($mes != null && $ano != null && $tiporeporte != null) {
                                    $query = "";

                                    if ($tiporeporte === 10 || $tiporeporte === '10') {
                                        $tiporeporte = "";
                                    } else {
                                        $tiporeporte = " AND reporte.idestatus = {$tiporeporte}";
                                    }

                                    if ($idrol == 1 || $idrol == 2) {

                                         if ($jsondecode->idcorporativo) {
                                            $idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                            if ($idcorporativo != -10 || $idcorporativo != "-10") {
                                                $query = "
                                            SELECT 
                                                DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y') as fecha, COUNT(*) as reportes 
                                            FROM 
                                                reporte LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                            WHERE 
                                                ( corporativo.idcorporativo = $idcorporativo ) AND MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} $tiporeporte
                                            GROUP BY
                                                DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y')";
                                            } else {
                                                $query = "
                                         SELECT 
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y') as fecha, COUNT(*) as reportes 
                                        FROM 
                                            reporte LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                        WHERE 
                                            MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} $tiporeporte
                                        GROUP BY
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y')";
                                            }
                                        } else {
                                            $query = "
                                         SELECT 
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y') as fecha, COUNT(*) as reportes 
                                        FROM 
                                            reporte LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                        WHERE 
                                            MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} $tiporeporte
                                        GROUP BY
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y')";
                                        }
                                    } else if ($idrol == 5 ) {

                                        $query = "
                                        SELECT 
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y') as fecha, COUNT(*) as reportes 
                                        FROM 
                                            reporte LEFT JOIN corporativo on corporativo.idcorporativo = reporte.idcorporativo
                                        WHERE 
                                            corporativo.idusuario = {$idusuario} AND MONTH(fechacreacion) = {$mes} AND YEAR(fechacreacion) = {$ano} $tiporeporte
                                        GROUP BY
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y')";
                                    } else if($idrol == 6){
                                        $idcorporativo = ( $jsondecode->idcorporativo != null ) ? $jsondecode->idcorporativo : null;
                                        
                                        $where ="";

                                        if ($idcorporativo != -10 || $idcorporativo != '-10') {
                                            $where = " AND coberturascor.idsubcorporativo = {$idcorporativo}";
                                        }

                                        $query = "
                                        SELECT 
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y') as fecha, COUNT(*) as reportes 
                                        FROM reporte 
                                            LEFT JOIN 
                                                corporativo on corporativo.idcorporativo = reporte.idcorporativo 
                                            LEFT JOIN  
                                                coberturascor on corporativo.idcorporativo = coberturascor.idsubcorporativo 
                                        WHERE 
                                            coberturascor.idusuariosubcorp = {$idusuario} AND "
                                                . "MONTH(fechacreacion) = {$mes} AND "
                                                . "YEAR(fechacreacion) = {$ano} $tiporeporte {$where}
                                        GROUP BY
                                            DATE_FORMAT(reporte.fechacreacion, '%d-%m-%Y')";
                                    }

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $datasetfechas = $stmt->fetchAll();
                                    
                                    if (count($datasetfechas) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "estadisticas encontradas!!",
                                            "dataset" => $datasetfechas
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 401,
                                            "msg" => "no hay Estadisticas!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "faltan datos!!"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "faltan datos!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

}
