<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;
use BackendBundle\Entity\Ciudad;
use BackendBundle\Entity\Usuario;
use BackendBundle\Entity\Estado;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of CiudadController
 *
 * @author brianaboytesmorales
 */
class CiudadController extends Controller {

    public function newAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        try {

            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);
            $json = $request->get("json", null);

            if ($json != null && $hash != null) {

                $params = json_decode($json);
                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {
                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        $permisos = $user->getIdrol()->getPermisos();

                        if ($permisos == 1 || $permisos == 2) {
                            $db = $em->getConnection();
                            $idestado = ( $params->idestado != null ) ? $params->idestado : null;
                            $nombreciudad = ( $params->nombreciudad != null ) ? $params->nombreciudad : null;

                            if ($idestado != null && $nombreciudad != null) {

                                $query = "SELECT * FROM "
                                        . "ciudad "
                                        . "WHERE "
                                        . "nombreciudad = '{$nombreciudad}'"
                                        . "AND "
                                        . "idestado = {$idestado} "
                                        . "AND "
                                        . "ciudadactiva = 1";

                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_ciudad = $stmt->fetchAll();

                                if (count($isset_ciudad) == 0) {

                                    
                                    $query = "INSERT INTO "
                                            . "ciudad "
                                            . "(idestado,nombreciudad) "
                                            . "VALUES "
                                            . "({$idestado},'{$nombreciudad}')";


                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "ciudad creado!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 402,
                                        "msg" => "La ciudad ya existe en la BD!!"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Ingrese un dato!!"
                                );
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }

    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $json = $request->get("json", null);
                    $params = json_decode($json);
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            if ($json != null) {

                                $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;

                                if ($idciudad != null) {

                                    $query = "SELECT "
                                                . "* "
                                            . "FROM "
                                                . "ciudad "
                                            . "INNER JOIN "
                                                . "estado on ciudad.idestado = estado.idestado"
                                            . "INNER JOIN "
                                                . "zona on estado.idzona = zona.idzona "
                                            . "WHERE "
                                            . "idciudad = {$idciudad} AND ciudadactiva = 1";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_ciudad = $stmt->fetchAll();

                                    if (count($isset_ciudad) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "ciudad encontrada!!",
                                            "ciudad" => $isset_ciudad
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "La ciudad no existe en la BD!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            } else {

                                $query = "SELECT "
                                        . "* "
                                        . "FROM "
                                            . "ciudad "
                                        . "INNER JOIN "
                                            . "estado on ciudad.idestado = estado.idestado "
                                        . "INNER JOIN "
                                            . "zona on estado.idzona = zona.idzona WHERE ciudadactiva = 1 ORDER BY (nombreciudad)";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_ciudad = $stmt->fetchAll();
                                if (count($isset_ciudad) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "estados encontradas!!",
                                        "ciudad" => $isset_ciudad
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "no hay ciudades en la BD!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function updateAction(Request $request) {

        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );

        $helpers = $this->get("app.helpers");
        $hash = $request->get("authorization", null);
        $json = $request->get("json", null);

        if ($json != null && $hash != null) {

            $params = json_decode($json);
            $authCheck = $helpers->authCheck($hash);

            if ($authCheck == true) { // si es un usuario valido entra
                $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 
                $rol = ( $identity->idrol != null ) ? $identity->idrol : null;
                if ($idusuario != null) {
                    $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                    $user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                            array(
                                "idusuario" => $idusuario,
                            )
                    );

                    //$permisos = $user->getIdrol()->getPermisos();

                    if ($rol == 1  || $rol == 2) {

                        $idestado = ( $params->idestado != null ) ? $params->idestado : null;
                        $idciudad = ( $params->idciudad != null ) ? $params->idciudad : null;
                        $nombreciudad = ( $params->nombreciudad != null ) ? $params->nombreciudad : null;
                        $ciudadactiva = ( $params->ciudadactiva != null ) ? $params->ciudadactiva : null;

                        if ($idestado != null && $nombreciudad != null) {

                            try {
                                $db = $em->getConnection();
                                $query = "UPDATE "
                                        . "ciudad "
                                        . "SET "
                                        . "nombreciudad = '{$nombreciudad}', idestado = {$idestado}, ciudadactiva = {$ciudadactiva} "
                                        . "WHERE "
                                        . "idciudad = {$idciudad}";


                                $stmt = $db->prepare($query);
                                $params = array();
                                $stmt->execute($params);

                                $data = array(
                                    "status" => "succes!!",
                                    "code" => 200,
                                    "msg" => "ciuad actualizada!!"
                                );
                            } catch (Exception $ex) {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Error en la coneccion con la BD"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "Ingrese un dato!!"
                            );
                        }
                    }
                }
            }
        }
        return $helpers->json($data);
    }

}
