<?php

namespace AppBundle\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\Controller;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\Validator\Constraints as Assert;
use Symfony\Component\HttpFoundation\JsonResponse;

header('Access-Control-Allow-Origin: *');
header("Access-Control-Allow-Headers: X-API-KEY, Origin, X-Requested-With, Content-Type, Accept, Access-Control-Request-Method");
header("Access-Control-Allow-Methods: GET, POST, OPTIONS, PUT, DELETE");
header("Allow: GET, POST, OPTIONS, PUT, DELETE");

/**
 * Description of AlmacenController
 *
 * @author brianaboytesmorales
 */
 
class AlmacenController extends Controller {
    
    public function selectAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );
                        
                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);
                            
                            if ($json != null) {
                                
                                $params = json_decode($json);
                                
                                $idtaller = ( $params->idtaller != null ) ? $params->idtaller : null;
                                $idmodelo = ( $params->idmodelo != null ) ? $params->idmodelo : null;

                                //SOLO SI SE LLAMA DESDE ALGUN REPORTE
                                if ($idtaller != null) {

                                    $query = "SELECT "
                                                . "refaccion.nombrerefaccion, almacen.idrefaccion, "
                                                . "almacen.idtaller, almacen.cantidad, almacen.precio, "
                                                . "servicio.idservicio, refaccion.cantidadmax, refaccion.descripcion "
                                            . "FROM "
                                                . "taller "
                                            . "INNER JOIN "
                                                . "almacen on taller.idtaller = almacen.idtaller "
                                            . "INNER JOIN "
                                                . "refaccion on refaccion.idrefaccion = almacen.idrefaccion "
                                            . "INNER JOIN "
                                                . "servicio on servicio.idservicio = refaccion.idservicio "
                                            . "WHERE "
                                                . "taller.idtaller = {$idtaller} "
                                            . "AND "
                                                . "refaccion.idmodelo = {$idmodelo} "
                                            . "GROUP BY "
                                                . "refaccion.nombrerefaccion, almacen.idrefaccion, "
                                                . "almacen.idtaller, almacen.cantidad, almacen.precio, "
                                                . "servicio.idservicio, refaccion.cantidadmax, refaccion.descripcion ORDER BY refaccion.nombrerefaccion";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $isset_refaccion = $stmt->fetchAll();

                                    if (count($isset_refaccion) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "refacciones encontradas!!",
                                            "almacen" => $isset_refaccion
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "La refaccion o el taller no existe en la BD!!"
                                        );
                                    }
                                } 
                                else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                                
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function setAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $precio = (isset($jsondecode->precio)) ? $jsondecode->precio : null;
                            $cantidad = (isset($jsondecode->cantidad)) ? $jsondecode->cantidad : null;
                            $idrefaccion = (isset($jsondecode->idrefaccion)) ? $jsondecode->idrefaccion : null;
                            $idtaller = (isset($jsondecode->idtaller)) ? $jsondecode->idtaller : null;

                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */

                            if ($idrefaccion != null && $idtaller != null) {



                                /////////////////////
                                $query = "SELECT * FROM "
                                        . "almacen WHERE "
                                        . "idrefaccion = {$idrefaccion} AND idtaller = {$idtaller}";


                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);

                                $params = array();

                                $stmt->execute($params);

                                $isset_refaccion = $stmt->fetchAll();

                                if (count($isset_refaccion) == 0) {

                                    if ($cantidad == null) {
                                        $cantidad = 0;
                                    }
                                    if ($precio == null) {
                                        $precio = 0;
                                    }

                                    $query = "INSERT INTO almacen "
                                            . "(idrefaccion, idtaller, cantidad, precio) "
                                            . "VALUES "
                                            . "({$idrefaccion},{$idtaller},{$cantidad},{$precio})";

                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);
                                    $params = array();
                                    $stmt->execute($params);

                                    if (count($stmt) != 0) {

                                        $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "almacen actualizado!!"
                                        );
                                    } else {
                                        $data = array(
                                            "status" => "error",
                                            "code" => 400,
                                            "msg" => "Error al insertar almacen!!"
                                        );
                                    }
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 401,
                                        "msg" => "La refaccion ya esta agregada!!"
                                    );
                                }
                                ////////////////////
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Faltan dato!!"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "El usuario no existe!!"
                            );
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
   public function updateAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {

                            $idrol = ( $identity->idrol != null ) ? $identity->idrol : null;

                            $json = $request->get("json", null);

                            $jsondecode = json_decode($json);

                            $precio = (isset($jsondecode->precio)) ? $jsondecode->precio : null;
                            $cantidad = (isset($jsondecode->cantidad)) ? $jsondecode->cantidad : null;
                            $idrefaccion = (isset($jsondecode->idrefaccion)) ? $jsondecode->idrefaccion : null;
                            $idtaller = (isset($jsondecode->idtaller)) ? $jsondecode->idtaller : null;


                            /* -----------------------CONDICINES DE BUSQUEDA------------------------ */
                            if ($idrefaccion != null && $idtaller != null) {
                                $set = "";
                                if ($cantidad != null) {
                                    $set = "cantidad = {$cantidad}";
                                }
                                if ($precio != null) {
                                    $set = "precio = {$precio}";
                                }

                                $query = "UPDATE "
                                        . "almacen "
                                        . "SET "
                                        . "{$set} "
                                        . "WHERE "
                                        . "idrefaccion = {$idrefaccion} "
                                        . "AND "
                                        . "idtaller = {$idtaller}";

                                $db = $em->getConnection();
                                $stmt = $db->prepare($query);
                                $params = array();
                                $stmt->execute($params);

                                if (count($stmt) != 0) {

                                    $data = array(
                                        "status" => "succes!!",
                                        "code" => 200,
                                        "msg" => "almacen actualizado!!"
                                    );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 401,
                                        "msg" => "Error al actualizar almacen!!"
                                    );
                                }
                            } else {
                                $data = array(
                                    "status" => "error",
                                    "code" => 400,
                                    "msg" => "Faltan dato!!"
                                );
                            }
                        } else {
                            $data = array(
                                "status" => "error",
                                "code" => 400,
                                "msg" => "El usuario no existe!!"
                            );
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
    public function deleteAction(Request $request) {
        $data = array(
            "status" => "error",
            "code" => 400,
            "msg" => "Authorization not valid"
        );
        try {
            $helpers = $this->get("app.helpers");
            $hash = $request->get("authorization", null);


            if ($hash != null) {

                $authCheck = $helpers->authCheck($hash);

                if ($authCheck == true) { // si es un usuario valido entra
                    $identity = $helpers->authCheck($hash, true); //obtiene el usuario con sus datos decodificados

                    $idusuario = ( $identity->sub != null ) ? $identity->sub : null; //obtiene el id del usuario 

                    if ($idusuario != null) {

                        $em = $this->getDoctrine()->getManager(); //iniciamos la instancia con doctrine 
                        $isset_user = $em->getRepository("BackendBundle:Usuario")->findOneBy(//obtenemos el usuario de la bd
                                array(
                                    "idusuario" => $idusuario,
                                )
                        );

                        if (count($isset_user) != 0) {
                            $json = $request->get("json", null);

                            if ($json != null) {

                                $params = json_decode($json);

                                $idtaller = ( $params->idtaller != null ) ? $params->idtaller : null;
                                $idrefaccion = ( $params->idrefaccion != null ) ? $params->idrefaccion : null;

                                //SOLO SI SE LLAMA DESDE ALGUN REPORTE
                                if ($idtaller != null) {

                                    $query = "DELETE FROM almacen WHERE idtaller = {$idtaller} AND idrefaccion = {$idrefaccion}";


                                    $db = $em->getConnection();
                                    $stmt = $db->prepare($query);

                                    $params = array();

                                    $stmt->execute($params);

                                    $data = array(
                                            "status" => "succes!!",
                                            "code" => 200,
                                            "msg" => "refacciones eliminada"
                                        );
                                } else {
                                    $data = array(
                                        "status" => "error",
                                        "code" => 400,
                                        "msg" => "Ingrese un dato!!"
                                    );
                                }
                            }
                        }
                    }
                }
            }
        } catch (Exception $ex) {
            $data = array(
                "status" => "error",
                "code" => 400,
                "msg" => "Error en la coneccion con la BD o en formatos de archivos"
            );
        }
        return $helpers->json($data);
    }
    
}
